#property link          "https://Indicatorszone.com/"
#property description   "Find More on IndicatorsZone.com"
#property indicator_separate_window
#property indicator_minimum -100.0
#property indicator_maximum 100.0
#property indicator_levelcolor SlateGray
#property indicator_levelstyle 1
#property indicator_buffers 8
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_color3 Black
#property indicator_color4 Black
#property indicator_color5 Black
#property indicator_color6 Black
#property indicator_color7 Black
#property indicator_color8 Black
#property indicator_width1 1
#property indicator_level1 60.0
#property indicator_width2 1
#property indicator_level2 53.0
#property indicator_level3 -50.0
#property indicator_level4 -60.0

extern int WavePeriod = 10;
extern int AvgPeriod = 21;
extern bool SoundAlert = FALSE;
extern bool EmailAlert = FALSE;
double g_ibuf_92[];
double g_ibuf_96[];
double g_ibuf_100[];
double g_ibuf_104[];
double g_ibuf_108[];
double g_ibuf_112[];
double g_ibuf_116[];
double g_ibuf_120[];
int gi_124 = -50;
int gi_128 = 53;
int gi_132;

int init() {
   Comment("");
   IndicatorShortName("TrendWave");
   SetIndexBuffer(0, g_ibuf_100);
   SetIndexLabel(0, "ESA");
   SetIndexStyle(0, DRAW_NONE);
   SetIndexDrawBegin(0, 0);
   SetIndexBuffer(1, g_ibuf_112);
   SetIndexLabel(1, "DD Values");
   SetIndexStyle(1, DRAW_NONE);
   SetIndexDrawBegin(1, 0);
   SetIndexBuffer(2, g_ibuf_104);
   SetIndexLabel(2, "DD");
   SetIndexStyle(2, DRAW_NONE);
   SetIndexDrawBegin(2, 0);
   SetIndexBuffer(3, g_ibuf_108);
   SetIndexLabel(3, "CI");
   SetIndexStyle(3, DRAW_NONE);
   SetIndexDrawBegin(3, 0);
   SetIndexBuffer(4, g_ibuf_92);
   SetIndexLabel(4, "Bull");
   SetIndexStyle(4, DRAW_LINE, STYLE_SOLID, 1, Lime);
   SetIndexDrawBegin(4, 0);
   SetIndexBuffer(5, g_ibuf_96);
   SetIndexLabel(5, "Bear");
   SetIndexStyle(5, DRAW_LINE, STYLE_SOLID, 1, Red);
   SetIndexDrawBegin(5, 0);
   SetIndexBuffer(6, g_ibuf_116);
   SetIndexLabel(6, "Buy Dot");
   SetIndexStyle(6, DRAW_ARROW, STYLE_SOLID, 2, Aqua);
   SetIndexArrow(6, 108);
   SetIndexDrawBegin(6, 0);
   SetIndexBuffer(7, g_ibuf_120);
   SetIndexLabel(7, "Sell Dot");
   SetIndexStyle(7, DRAW_ARROW, STYLE_SOLID, 2, Yellow);
   SetIndexArrow(7, 108);
   SetIndexDrawBegin(7, 0);
   ArrayResize(g_ibuf_100, Bars);
   ArrayResize(g_ibuf_112, Bars);
   ArrayResize(g_ibuf_104, Bars);
   ArrayResize(g_ibuf_108, Bars);
   ArrayResize(g_ibuf_92, Bars);
   ArrayResize(g_ibuf_96, Bars);
   ArrayResize(g_ibuf_116, Bars);
   ArrayResize(g_ibuf_120, Bars);
   return (0);
}

int start() {
   double l_ima_on_arr_0;
   Comment("");
   int li_8 = IndicatorCounted();
   if (li_8 < 0) return (-1);
   if (li_8 > 0) li_8--;
   int li_12 = Bars - li_8;
   for (int li_16 = li_12; li_16 > 0; li_16--) {
      g_ibuf_100[li_16] = iMA(NULL, 0, WavePeriod, 0, MODE_EMA, PRICE_TYPICAL, li_16);
      ArraySetAsSeries(g_ibuf_100, TRUE);
   }
   for (li_16 = li_12; li_16 > 0; li_16--) {
      g_ibuf_112[li_16] = MathAbs((iHigh(NULL, 0, li_16) + iClose(NULL, 0, li_16) + iLow(NULL, 0, li_16)) / 3.0 - g_ibuf_100[li_16]);
      ArraySetAsSeries(g_ibuf_112, TRUE);
   }
   for (li_16 = li_12; li_16 > 0; li_16--) {
      l_ima_on_arr_0 = iMAOnArray(g_ibuf_112, 0, WavePeriod, 0, MODE_EMA, li_16);
      g_ibuf_104[li_16] = l_ima_on_arr_0;
      ArraySetAsSeries(g_ibuf_104, TRUE);
   }
   for (li_16 = li_12; li_16 > 0; li_16--) {
      if (g_ibuf_104[li_16] > 0.0) g_ibuf_108[li_16] = ((iHigh(NULL, 0, li_16) + iClose(NULL, 0, li_16) + iLow(NULL, 0, li_16)) / 3.0 - g_ibuf_100[li_16]) / (0.015 * g_ibuf_104[li_16]);
      else g_ibuf_108[li_16] = 0;
      ArraySetAsSeries(g_ibuf_108, TRUE);
   }
   for (li_16 = li_12; li_16 > 0; li_16--) {
      l_ima_on_arr_0 = iMAOnArray(g_ibuf_108, 0, AvgPeriod, 0, MODE_EMA, li_16);
      g_ibuf_92[li_16] = l_ima_on_arr_0;
      ArraySetAsSeries(g_ibuf_92, TRUE);
   }
   for (li_16 = li_12; li_16 > 0; li_16--) {
      l_ima_on_arr_0 = iMAOnArray(g_ibuf_92, 0, 4, 0, MODE_SMA, li_16);
      g_ibuf_96[li_16] = l_ima_on_arr_0;
      ArraySetAsSeries(g_ibuf_96, TRUE);
   }
   for (li_16 = li_12; li_16 > 0; li_16--) {
      if (g_ibuf_92[li_16] >= g_ibuf_96[li_16] && g_ibuf_92[li_16 + 1] <= g_ibuf_96[li_16 + 1] && g_ibuf_92[li_16] < gi_124) {
         g_ibuf_116[li_16] = g_ibuf_92[li_16];
         SendAlert("buy");
      } else g_ibuf_116[li_16] = -1000;
      if (g_ibuf_92[li_16] <= g_ibuf_96[li_16] && g_ibuf_92[li_16 + 1] >= g_ibuf_96[li_16 + 1] && g_ibuf_92[li_16] > gi_128) {
         g_ibuf_120[li_16] = g_ibuf_96[li_16];
         SendAlert("sell");
      } else g_ibuf_120[li_16] = -1000;
   }
   return (0);
}

void SendAlert(string as_0) {
   if (Time[0] != gi_132) {
      if (SoundAlert) {
         if (as_0 == "buy") Alert(Symbol() + " => " + TimeToStr(TimeCurrent()) + " buy");
         if (as_0 == "sell") Alert(Symbol() + " => " + TimeToStr(TimeCurrent()) + " sell");
      }
      if (EmailAlert) {
         if (as_0 == "buy") SendMail("TrendWave Alert", Symbol() + " => " + TimeToStr(TimeCurrent()) + " buy");
         if (as_0 == "sell") SendMail("TrendWave Alert", Symbol() + " => " + TimeToStr(TimeCurrent()) + " sell");
      }
      gi_132 = Time[0];
   }
}