#property link          "https://Indicatorszone.com/"
#property description   "Find More on IndicatorsZone.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_color3 Black

extern int ArrowDistance = 3;
extern bool WaitForCandleClose = TRUE;
extern bool ArrowOnTriggerBar = FALSE;
extern bool AlertOn = true;
extern bool EmailOn = false;
double G_ibuf_88[];
double G_ibuf_92[];
double G_ibuf_96[];
int Gi_100 = 0;
int Gi_104 = 0;
int Gi_108 = 0;
int Trend=0;
datetime Signal=0,LastSignal=0;

int init() {
   if (WaitForCandleClose) Gi_104 = 1;
   else Gi_104 = 0;
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexBuffer(0, G_ibuf_88);
   SetIndexArrow(0, 233);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexBuffer(1, G_ibuf_92);
   SetIndexArrow(1, 234);
   SetIndexStyle(2, DRAW_NONE);
   SetIndexBuffer(2, G_ibuf_96);
   return (0);
}

int deinit() {
   return (0);
}

int start() {
   int ind_counted_4 = IndicatorCounted();
   int Li_0 = Bars - ind_counted_4 - 1;
   if (Li_0 == 0) Li_0 = 5;
   while (Li_0 > Gi_104) {
      if (f0_2(Li_0)) {
         if (ArrowOnTriggerBar) Gi_108 = Gi_100;
         else Gi_108 = 0;
         if (Gi_100 == 1 || (Gi_100 == 2 && Li_0 > Gi_104 + 1)) {
            G_ibuf_88[Li_0 - Gi_108] = Low[Li_0 - Gi_108] - ArrowDistance * Point;
            G_ibuf_92[Li_0 - Gi_108] = EMPTY_VALUE;
            G_ibuf_96[Li_0] = Gi_100;
            Signal=Time[Li_0-Gi_108];
            Trend=1;
         }
      } else {
         if (f0_3(Li_0)) {
            if (ArrowOnTriggerBar) Gi_108 = Gi_100;
            else Gi_108 = 0;
            if (Gi_100 == 1 || (Gi_100 == 2 && Li_0 > Gi_104 + 1)) {
               G_ibuf_92[Li_0 - Gi_108] = High[Li_0 - Gi_108] + ArrowDistance * Point;
               G_ibuf_88[Li_0 - Gi_108] = EMPTY_VALUE;
               G_ibuf_96[Li_0] = Gi_100;
               Signal=Time[Li_0-Gi_108];
               Trend=-1;
            }
         } else {
            if (ArrowOnTriggerBar) Gi_108 = G_ibuf_96[Li_0];
            else Gi_108 = 0;
            G_ibuf_88[Li_0 - Gi_108] = EMPTY_VALUE;
            G_ibuf_92[Li_0 - Gi_108] = EMPTY_VALUE;
            G_ibuf_96[Li_0] = EMPTY_VALUE;
         }
      }
      Li_0--;
   }
   if (LastSignal==Signal) return(0);
   if (Trend>0) {
      if (AlertOn) Alert("NoRepaint Buy Alert - "+Symbol()+"["+Period()+"m]");
      if (EmailOn) SendMail("NoRepaint Buy Alert","Buy Alert - "+Symbol()+"["+Period()+"m]");
      LastSignal=Signal;
      }
   else if (Trend<0) {
      if (AlertOn) Alert("NoRepaint Sell Alert - "+Symbol()+"["+Period()+"m]");
      if (EmailOn) SendMail("NoRepaint Sell Alert","Sell Alert - "+Symbol()+"["+Period()+"m]");
      LastSignal=Signal;
      }
   return (0);
}

int f0_2(int Ai_0) {
   if (f0_0(Ai_0) && f0_4(Ai_0)) return (1);
   return (0);
}

int f0_0(int Ai_0) {
   if (Low[Ai_0] < Low[Ai_0 + 1]) {
      if (High[Ai_0] < High[Ai_0 + 1]) return (1);
      if (Low[Ai_0] < Low[Ai_0 + 2] && High[Ai_0] < High[Ai_0 + 2]) return (1);
   }
   return (0);
}

int f0_4(int Ai_0) {
   if (Low[Ai_0] < Low[Ai_0 - 1]) {
      if (High[Ai_0] < High[Ai_0 - 1]) {
         Gi_100 = 1;
         return (1);
      }
      if (Low[Ai_0] < Low[Ai_0 - 2] && High[Ai_0] < High[Ai_0 - 2]) {
         Gi_100 = 2;
         return (1);
      }
   }
   return (0);
}

int f0_3(int Ai_0) {
   if (f0_5(Ai_0) && f0_1(Ai_0)) return (1);
   return (0);
}

int f0_5(int Ai_0) {
   if (High[Ai_0] > High[Ai_0 + 1]) {
      if (Low[Ai_0] > Low[Ai_0 + 1]) return (1);
      if (Low[Ai_0] > Low[Ai_0 + 2] && High[Ai_0] > High[Ai_0 + 2]) return (1);
   }
   return (0);
}

int f0_1(int Ai_0) {
   if (High[Ai_0] > High[Ai_0 - 1]) {
      if (Low[Ai_0] > Low[Ai_0 - 1]) {
         Gi_100 = 1;
         return (1);
      }
      if (Low[Ai_0] > Low[Ai_0 - 2] && High[Ai_0] > High[Ai_0 - 2]) {
         Gi_100 = 2;
         return (1);
      }
   }
   return (0);
}
